
////////////////////////////////////////////////////////////
//	File:		"Sprite.h"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 17, 2008
//	Purpose:	Holds all the animations for a given sprite sheet.
////////////////////////////////////////////////////////////

#ifndef SPRITE_H_
#define SPRITE_H_

#include "Animation.h"

class CSprite
{

public:

	/* Public Data Members */

protected:

	/* Protected Data Members */

private:

	/* Private Data Members */

	string				m_szSpriteSheetName;	// name of the sprite sheet file
	vector<CAnimation*>	m_vAnimationList;		// list of animations for this sprite sheet
	int					m_nImageID;				// image id from the texture manager

	/* Disabled Functions */

public:

	////////////////////////////////////////////////////////////
	//	Function:	Constructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Initializes the object.
	////////////////////////////////////////////////////////////
	CSprite();
	CSprite(string szSpriteSheetName);

	////////////////////////////////////////////////////////////
	//	Function:	Accessors
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Gets the specified type.
	////////////////////////////////////////////////////////////
	inline string GetSpriteName(void)	{ return m_szSpriteSheetName; }
	inline int GetImageID(void)			{ return m_nImageID; }

	////////////////////////////////////////////////////////////
	//	Function:	Mutators
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Sets the specified type.
	////////////////////////////////////////////////////////////
	inline void SetImageID(int nImageID)	{ m_nImageID = nImageID; }

	////////////////////////////////////////////////////////////
	//	Function:	Destructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Deallocates the object.
	////////////////////////////////////////////////////////////
	~CSprite();

	////////////////////////////////////////////////////////////
	//	Function:	AddAnimation
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Adds a specified animation to the list.
	////////////////////////////////////////////////////////////
	inline void AddAnimation(CAnimation *pAnim) 
		{ m_vAnimationList.push_back(pAnim); }

	////////////////////////////////////////////////////////////
	//	Function:	AddFrame
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Adds a specified frae to an animation.
	////////////////////////////////////////////////////////////
	inline void AddFrame(const int nAnimation, CFrame *pFrame) 
		{ m_vAnimationList[nAnimation]->AddFrame(pFrame); }

	////////////////////////////////////////////////////////////
	//	Function:	GetAnimation
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Returns the given animation.
	////////////////////////////////////////////////////////////
	CAnimation* GetAnimation(const string szAnimName);

	////////////////////////////////////////////////////////////
	//	Function:	GetAnimation
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Returns the given animation.
	////////////////////////////////////////////////////////////
	CAnimation* GetAnimation(const int nAnimIndex)
		{ return m_vAnimationList[nAnimIndex]; }

	////////////////////////////////////////////////////////////
	//	Function:	Clear
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Removes all the animations and their frames.
	////////////////////////////////////////////////////////////
	void Clear();

protected:

	/* Protected Functions */

private:

	/* Private Functions */

};

#endif
